<?php
declare(strict_types=1);

/**
 * Module Interface
 *
 * @package ProRank\Contracts
 */

namespace ProRank\SEO\Contracts;

defined( 'ABSPATH' ) || exit;

/**
 * Interface for all ProRank modules
 */
interface ModuleInterface {
    
    /**
     * Get module ID
     *
     * @return string
     */
    public function id(): string;
    
    /**
     * Get required tier
     *
     * @return string
     */
    public function tier_required(): string;
    
    /**
     * Get settings group
     *
     * @return string
     */
    public function settings_group(): string;
    
    /**
     * Initialize module hooks
     *
     * @return void
     */
    public function init_hooks(): void;
}