<?php
/**
 * Module Slugs Constants
 *
 * Auto-generated from docs/ia-modules.json
 * DO NOT EDIT MANUALLY - use npm run build to regenerate
 *
 * @package ProRank\SEO\Core\Constants
 * @since   0.1.0
 */

declare(strict_types=1);

namespace ProRank\SEO\Core\Constants;

defined( 'ABSPATH' ) || exit;

/**
 * Module slugs constants and data
 */
class ModuleSlugs {
    
    /**
     * Module slug constants
     */
    public const SLUG_DASHBOARD = 'dashboard';
    public const SLUG_ON_PAGE_SEO = 'on-page-seo';
    public const SLUG_TITLES_META = 'titles-meta';
    public const SLUG_BREADCRUMBS = 'breadcrumbs';
    public const SLUG_CONTENT_ANALYSIS = 'content-analysis';
    public const SLUG_SCHEMA_MARKUP = 'schema-markup';
    public const SLUG_INTERNAL_LINKING = 'internal-linking';
    public const SLUG_PERFORMANCE = 'performance';
    public const SLUG_PAGE_CACHING = 'page-caching';
    public const SLUG_IMAGE_OPTIMIZATION = 'image-optimization';
    public const SLUG_LAZY_LOADING = 'lazy-loading';
    public const SLUG_MINIFICATION = 'minification';
    public const SLUG_TECHNICAL_SEO = 'technical-seo';
    public const SLUG_SITEMAPS = 'sitemaps';
    public const SLUG_REDIRECTS = 'redirects';
    public const SLUG_ROBOTS_TXT = 'robots-txt';
    public const SLUG_HTACCESS_EDITOR = 'htaccess-editor';
    public const SLUG_LOCAL_SEO = 'local-seo';
    public const SLUG_BUSINESS_INFO = 'business-info';
    public const SLUG_MAPS = 'maps';
    public const SLUG_REVIEWS = 'reviews';
    public const SLUG_CITATIONS = 'citations';
    public const SLUG_ECOMMERCE_SEO = 'ecommerce-seo';
    public const SLUG_PRODUCT_SCHEMA = 'product-schema';
    public const SLUG_WOOCOMMERCE_INTEGRATION = 'woocommerce-integration';
    public const SLUG_SHOPPING_FEEDS = 'shopping-feeds';
    public const SLUG_ANALYTICS = 'analytics';
    public const SLUG_SEARCH_CONSOLE = 'search-console';
    public const SLUG_GOOGLE_ANALYTICS = 'google-analytics';
    public const SLUG_RANK_TRACKING = 'rank-tracking';
    public const SLUG_REPORTING = 'reporting';
    public const SLUG_AI_TOOLS = 'ai-tools';
    public const SLUG_CONTENT_GENERATION = 'content-generation';
    public const SLUG_KEYWORD_RESEARCH = 'keyword-research';
    public const SLUG_COMPETITOR_ANALYSIS = 'competitor-analysis';
    public const SLUG_SITE_AUDIT = 'site-audit';
    public const SLUG_CRAWL_ERRORS = 'crawl-errors';
    public const SLUG_BROKEN_LINKS = 'broken-links';
    public const SLUG_SECURITY_SCAN = 'security-scan';
    public const SLUG_PERFORMANCE_AUDIT = 'performance-audit';
    public const SLUG_AGENCY_HUB = 'agency-hub';
    public const SLUG_WHITE_LABEL = 'white-label';
    public const SLUG_CLIENT_REPORTING = 'client-reporting';
    public const SLUG_MULTI_SITE_MANAGEMENT = 'multi-site-management';
    public const SLUG_SUPPORT = 'support';
    
    /**
     * Module data array
     *
     * @var array<string, array{name: string, tier: string, parent: ?string, description: string, icon_token: string}>
     */
    public const MODULE_DATA = [
        'dashboard' => [
            'name' => 'Dashboard',
            'tier' => 'free',
            'parent' => null,
            'description' => 'SEO overview and insights dashboard',
            'icon_token' => '--pr-icon-dashboard',
        ],
        'on-page-seo' => [
            'name' => 'On-Page SEO',
            'tier' => 'free',
            'parent' => null,
            'description' => 'On-page optimization tools and analysis',
            'icon_token' => '--pr-icon-on-page',
        ],
        'titles-meta' => [
            'name' => 'Titles & Meta',
            'tier' => 'free',
            'parent' => 'on-page-seo',
            'description' => 'Manage page titles and meta descriptions',
            'icon_token' => '--pr-icon-titles-meta',
        ],
        'breadcrumbs' => [
            'name' => 'Breadcrumbs',
            'tier' => 'free',
            'parent' => 'on-page-seo',
            'description' => 'Navigational breadcrumbs with schema markup',
            'icon_token' => '--pr-icon-breadcrumbs',
        ],
        'content-analysis' => [
            'name' => 'Content Analysis',
            'tier' => 'free',
            'parent' => 'on-page-seo',
            'description' => 'Real-time content optimization suggestions',
            'icon_token' => '--pr-icon-content-analysis',
        ],
        'schema-markup' => [
            'name' => 'Schema Markup',
            'tier' => 'free',
            'parent' => 'on-page-seo',
            'description' => 'Structured data and rich snippets',
            'icon_token' => '--pr-icon-schema',
        ],
        'internal-linking' => [
            'name' => 'Internal Linking',
            'tier' => 'free',
            'parent' => 'on-page-seo',
            'description' => 'Smart internal link suggestions',
            'icon_token' => '--pr-icon-internal-linking',
        ],
        'performance' => [
            'name' => 'Performance',
            'tier' => 'free',
            'parent' => null,
            'description' => 'Site speed and Core Web Vitals optimization',
            'icon_token' => '--pr-icon-performance',
        ],
        'page-caching' => [
            'name' => 'Page Caching',
            'tier' => 'pro',
            'parent' => 'performance',
            'description' => 'Built-in page caching system',
            'icon_token' => '--pr-icon-cache',
        ],
        'image-optimization' => [
            'name' => 'Image Optimization',
            'tier' => 'free',
            'parent' => 'performance',
            'description' => 'Optimize images for faster loading',
            'icon_token' => '--pr-icon-image-optimize',
        ],
        'lazy-loading' => [
            'name' => 'Lazy Loading',
            'tier' => 'free',
            'parent' => 'performance',
            'description' => 'Defer loading of off-screen content',
            'icon_token' => '--pr-icon-lazy-load',
        ],
        'minification' => [
            'name' => 'Minification',
            'tier' => 'free',
            'parent' => 'performance',
            'description' => 'Minify CSS, JavaScript, and HTML',
            'icon_token' => '--pr-icon-minify',
        ],
        'technical-seo' => [
            'name' => 'Technical SEO',
            'tier' => 'free',
            'parent' => null,
            'description' => 'Technical optimization and site health',
            'icon_token' => '--pr-icon-technical',
        ],
        'sitemaps' => [
            'name' => 'XML Sitemaps',
            'tier' => 'free',
            'parent' => 'technical-seo',
            'description' => 'Automatic XML sitemap generation',
            'icon_token' => '--pr-icon-sitemap',
        ],
        'redirects' => [
            'name' => 'Redirects',
            'tier' => 'free',
            'parent' => 'technical-seo',
            'description' => 'Manage 301/302 redirects',
            'icon_token' => '--pr-icon-redirects',
        ],
        'robots-txt' => [
            'name' => 'Robots.txt Editor',
            'tier' => 'free',
            'parent' => 'technical-seo',
            'description' => 'Edit robots.txt file',
            'icon_token' => '--pr-icon-robots',
        ],
        'htaccess-editor' => [
            'name' => '.htaccess Editor',
            'tier' => 'pro',
            'parent' => 'technical-seo',
            'description' => 'Advanced .htaccess file editing',
            'icon_token' => '--pr-icon-htaccess',
        ],
        'local-seo' => [
            'name' => 'Local SEO',
            'tier' => 'pro',
            'parent' => null,
            'description' => 'Local business optimization tools',
            'icon_token' => '--pr-icon-local',
        ],
        'business-info' => [
            'name' => 'Business Information',
            'tier' => 'pro',
            'parent' => 'local-seo',
            'description' => 'Manage local business details',
            'icon_token' => '--pr-icon-business',
        ],
        'maps' => [
            'name' => 'Maps Integration',
            'tier' => 'pro',
            'parent' => 'local-seo',
            'description' => 'Google Maps and location features',
            'icon_token' => '--pr-icon-maps',
        ],
        'reviews' => [
            'name' => 'Review Management',
            'tier' => 'pro',
            'parent' => 'local-seo',
            'description' => 'Monitor and manage customer reviews',
            'icon_token' => '--pr-icon-reviews',
        ],
        'citations' => [
            'name' => 'Citation Tracking',
            'tier' => 'pro',
            'parent' => 'local-seo',
            'description' => 'Track business directory listings',
            'icon_token' => '--pr-icon-citations',
        ],
        'ecommerce-seo' => [
            'name' => 'eCommerce SEO',
            'tier' => 'pro',
            'parent' => null,
            'description' => 'E-commerce SEO optimization',
            'icon_token' => '--pr-icon-ecommerce',
        ],
        'product-schema' => [
            'name' => 'Product Schema',
            'tier' => 'pro',
            'parent' => 'ecommerce-seo',
            'description' => 'Rich product markup for search results',
            'icon_token' => '--pr-icon-product-schema',
        ],
        'woocommerce-integration' => [
            'name' => 'WooCommerce Integration',
            'tier' => 'pro',
            'parent' => 'ecommerce-seo',
            'description' => 'Deep WooCommerce SEO integration',
            'icon_token' => '--pr-icon-woocommerce',
        ],
        'shopping-feeds' => [
            'name' => 'Shopping Feeds',
            'tier' => 'pro',
            'parent' => 'ecommerce-seo',
            'description' => 'Product feed optimization',
            'icon_token' => '--pr-icon-shopping-feeds',
        ],
        'analytics' => [
            'name' => 'Analytics',
            'tier' => 'pro',
            'parent' => null,
            'description' => 'SEO analytics and reporting',
            'icon_token' => '--pr-icon-analytics',
        ],
        'search-console' => [
            'name' => 'Search Console Integration',
            'tier' => 'pro',
            'parent' => 'analytics',
            'description' => 'Google Search Console data integration',
            'icon_token' => '--pr-icon-search-console',
        ],
        'google-analytics' => [
            'name' => 'Google Analytics',
            'tier' => 'pro',
            'parent' => 'analytics',
            'description' => 'GA4 tracking and integration',
            'icon_token' => '--pr-icon-analytics',
        ],
        'rank-tracking' => [
            'name' => 'Rank Tracking',
            'tier' => 'pro',
            'parent' => 'analytics',
            'description' => 'Monitor keyword rankings',
            'icon_token' => '--pr-icon-rank-tracking',
        ],
        'reporting' => [
            'name' => 'SEO Reports',
            'tier' => 'pro',
            'parent' => 'analytics',
            'description' => 'Automated SEO reporting',
            'icon_token' => '--pr-icon-reports',
        ],
        'ai-tools' => [
            'name' => 'AI Tools',
            'tier' => 'pro',
            'parent' => null,
            'description' => 'AI-powered SEO suggestions and content',
            'icon_token' => '--pr-icon-ai',
        ],
        'content-generation' => [
            'name' => 'AI Content Generation',
            'tier' => 'pro',
            'parent' => 'ai-tools',
            'description' => 'Generate SEO-optimized content with AI',
            'icon_token' => '--pr-icon-ai-content',
        ],
        'keyword-research' => [
            'name' => 'AI Keyword Research',
            'tier' => 'pro',
            'parent' => 'ai-tools',
            'description' => 'AI-powered keyword suggestions',
            'icon_token' => '--pr-icon-ai-keywords',
        ],
        'competitor-analysis' => [
            'name' => 'Competitor Analysis',
            'tier' => 'pro',
            'parent' => 'ai-tools',
            'description' => 'AI competitor insights',
            'icon_token' => '--pr-icon-ai-competitor',
        ],
        'site-audit' => [
            'name' => 'Site Audit & Tools',
            'tier' => 'free',
            'parent' => null,
            'description' => 'Comprehensive site analysis tools',
            'icon_token' => '--pr-icon-site-audit',
        ],
        'crawl-errors' => [
            'name' => 'Crawl Error Detection',
            'tier' => 'free',
            'parent' => 'site-audit',
            'description' => 'Find and fix crawl errors',
            'icon_token' => '--pr-icon-crawl-errors',
        ],
        'broken-links' => [
            'name' => 'Broken Link Checker',
            'tier' => 'pro',
            'parent' => 'site-audit',
            'description' => 'Find and fix broken links',
            'icon_token' => '--pr-icon-broken-links',
        ],
        'security-scan' => [
            'name' => 'Security Scan',
            'tier' => 'pro',
            'parent' => 'site-audit',
            'description' => 'SEO security vulnerability scan',
            'icon_token' => '--pr-icon-security',
        ],
        'performance-audit' => [
            'name' => 'Performance Audit',
            'tier' => 'free',
            'parent' => 'site-audit',
            'description' => 'Core Web Vitals analysis',
            'icon_token' => '--pr-icon-performance-audit',
        ],
        'agency-hub' => [
            'name' => 'Agency Hub',
            'tier' => 'business',
            'parent' => null,
            'description' => 'Manage multiple client sites',
            'icon_token' => '--pr-icon-agency',
        ],
        'white-label' => [
            'name' => 'White Label Branding',
            'tier' => 'business',
            'parent' => 'agency-hub',
            'description' => 'Customize plugin branding',
            'icon_token' => '--pr-icon-white-label',
        ],
        'client-reporting' => [
            'name' => 'Client Reporting',
            'tier' => 'business',
            'parent' => 'agency-hub',
            'description' => 'Automated client SEO reports',
            'icon_token' => '--pr-icon-client-reports',
        ],
        'multi-site-management' => [
            'name' => 'Multi-Site Management',
            'tier' => 'agency',
            'parent' => 'agency-hub',
            'description' => 'Manage SEO across multiple sites',
            'icon_token' => '--pr-icon-multi-site',
        ],
        'support' => [
            'name' => 'Support & Account',
            'tier' => 'free',
            'parent' => null,
            'description' => 'Help resources and account management',
            'icon_token' => '--pr-icon-support',
        ],
    ];
    
    /**
     * Get module data by slug
     *
     * @param string $slug Module slug
     * @return array{name: string, tier: string, parent: ?string, description: string, icon_token: string}|null
     */
    public static function getModuleData(string $slug): ?array {
        return self::MODULE_DATA[$slug] ?? null;
    }
    
    /**
     * Get all module slugs
     *
     * @return string[]
     */
    public static function getAllSlugs(): array {
        return array_keys(self::MODULE_DATA);
    }
    
    /**
     * Get modules by tier
     *
     * @param string $tier Tier name
     * @return array<string, array{name: string, tier: string, parent: ?string, description: string, icon_token: string}>
     */
    public static function getModulesByTier(string $tier): array {
        return array_filter(
            self::MODULE_DATA,
            fn($module) => $module['tier'] === $tier
        );
    }
    
    /**
     * Get child modules
     *
     * @param string $parentSlug Parent module slug
     * @return array<string, array{name: string, tier: string, parent: ?string, description: string, icon_token: string}>
     */
    public static function getChildModules(string $parentSlug): array {
        return array_filter(
            self::MODULE_DATA,
            fn($module) => $module['parent'] === $parentSlug
        );
    }
}