<?php

declare(strict_types=1);

/**
 * Initialize AI Enhancement Defaults
 * 
 * This file is loaded on plugin activation and ensures AI features are enabled by default
 */

if (!defined('ABSPATH')) {
    exit;
}

// Set default values for AI enhancement settings - enabled by default for commercial plugin
$prorank_ai_defaults = [
    'prorank_seo_enable_ai_schema_enhancement' => true,
    'prorank_seo_ai_detect_brand' => true,
    'prorank_seo_ai_generate_descriptions' => true,
    'prorank_seo_ai_extract_features' => true,
    'prorank_seo_ai_generate_faq' => true,
    'prorank_seo_ai_detect_energy' => true,
    'prorank_seo_ai_detect_sustainability' => true,
    'prorank_seo_ai_detect_warranty' => true,
];

foreach ($prorank_ai_defaults as $prorank_option_name => $prorank_default_value) {
    // Only set if option doesn't exist yet
    if (get_option($prorank_option_name, null) === null) {
        add_option($prorank_option_name, $prorank_default_value);
    }
}
