<?php
declare(strict_types=1);

namespace ProRank\SEO\Core;

defined( 'ABSPATH' ) || exit;

class ServiceContainer {
    private $services = [];
    private $factories = [];
    
    public function register($name, $factory) {
        $this->factories[$name] = $factory;
    }
    
    public function get($name) {
        if (!isset($this->services[$name])) {
            if (!isset($this->factories[$name])) {
                // phpcs:ignore WordPress.Security.EscapeOutput.ExceptionNotEscaped -- Internal exception message
                throw new \Exception(sprintf('Service "%s" not found in container', esc_html($name)));
            }
            
            $this->services[$name] = $this->factories[$name]();
        }
        
        return $this->services[$name];
    }
    
    public function has($name) {
        return isset($this->factories[$name]) || isset($this->services[$name]);
    }
}
