<?php
/**
 * Internal Linking Module
 *
 * Provides basic internal linking suggestions and editor integration.
 *
 * @package ProRank\SEO\Modules\Content
 * @since   1.0.0
 */

declare(strict_types=1);

namespace ProRank\SEO\Modules\Content;

defined( 'ABSPATH' ) || exit;

use ProRank\SEO\Core\RestApi\LinkingController;
use ProRank\SEO\Modules\BaseModule;

class InternalLinkingModule extends BaseModule {
    protected string $slug = 'internal-linking';

    protected string $name = 'Internal Linking';

    protected string $description = 'Get basic internal linking suggestions while editing content.';

    protected string $feature_tier = 'free';

    protected ?string $parent_slug = 'on-page-seo';

    public function init_hooks(): void {
        add_action('rest_api_init', [$this, 'register_rest_controller'], 5);

        if (class_exists('\\ProRank\\SEO\\Admin\\EditorIntegration')) {
            \ProRank\SEO\Admin\EditorIntegration::init();
        }
    }

    public function register_rest_controller(): void {
        if (class_exists(LinkingController::class)) {
            (new LinkingController())->register_routes();
        }
    }
}
