<?php
/**
 * Dynamic Variables Module
 *
 * Exposes dynamic variables tooling for titles/meta fields.
 *
 * @package ProRank\SEO\Modules\Meta
 * @since   1.0.0
 */

declare(strict_types=1);

namespace ProRank\SEO\Modules\Meta;

defined( 'ABSPATH' ) || exit;

use ProRank\SEO\Core\RestApi\DynamicVariablesController;
use ProRank\SEO\Modules\BaseModule;

class DynamicVariablesModule extends BaseModule {
    protected string $slug = 'dynamic-variables';

    protected string $name = 'Dynamic Variables';

    protected string $description = 'Use %%variables%% in titles and meta descriptions.';

    protected string $feature_tier = 'free';

    protected ?string $parent_slug = 'titles-meta';

    public function init_hooks(): void {
        add_action('rest_api_init', [$this, 'register_rest_routes'], 5);
    }

    public function register_rest_routes(): void {
        if (class_exists(DynamicVariablesController::class)) {
            (new DynamicVariablesController())->register_routes();
        }
    }
}
