<?php
/**
 * ProRank.io Domain Configuration Constants
 *
 * Add these constants to your wp-config.php file for centralized domain management.
 * This ensures all API endpoints and external URLs use the correct domain.
 *
 * @package ProRank\SEO
 * @since 1.0.0
 */

defined( 'ABSPATH' ) || exit;

// ProRank.io Configuration - Auto-detect environment
if (!defined('PRORANK_API_BASE')) {
    // Get current site URL and extract domain
    $prorank_site_url = defined('WP_SITEURL') ? WP_SITEURL : get_site_url();
    $prorank_site_host = wp_parse_url($prorank_site_url, PHP_URL_HOST);

    // Only use test API when running on test.prorank.io (internal testing)
    // All customer sites use production API at prorank.io
    if (strpos($prorank_site_host, 'test.prorank.io') !== false) {
        define('PRORANK_API_BASE', 'https://test.prorank.io/api');
    } elseif (strpos($prorank_site_host, 'dev.prorank.io') !== false) {
        define('PRORANK_API_BASE', 'https://dev.prorank.io/api');
    } elseif (strpos($prorank_site_host, 'staging.prorank.io') !== false) {
        define('PRORANK_API_BASE', 'https://staging.prorank.io/api');
    } else {
        // Production API for all customer installations
        define('PRORANK_API_BASE', 'https://prorank.io/api');
    }
}

// JWT operations are handled server-side only for security
// Plugin only sends license key, server handles JWT internally

if (!defined('PRORANK_WEB_URL')) {
    define('PRORANK_WEB_URL', 'https://prorank.io');
}

if (!defined('PRORANK_DOCS_URL')) {
    define('PRORANK_DOCS_URL', 'https://prorank.io/docs');
}

if (!defined('PRORANK_SUPPORT_URL')) {
    define('PRORANK_SUPPORT_URL', 'https://prorank.io/support');
}

if (!defined('PRORANK_ACCOUNT_URL')) {
    define('PRORANK_ACCOUNT_URL', 'https://prorank.io/account');
}

if (!defined('PRORANK_CDN_URL')) {
    define('PRORANK_CDN_URL', 'https://cdn.prorank.io');
}

// API Endpoints
if (!defined('PRORANK_TELEMETRY_ENDPOINT')) {
    define('PRORANK_TELEMETRY_ENDPOINT', PRORANK_API_BASE . '/v1/telemetry');
}

if (!defined('PRORANK_NOTIFICATIONS_ENDPOINT')) {
    define('PRORANK_NOTIFICATIONS_ENDPOINT', PRORANK_API_BASE . '/v1/notifications');
}

if (!defined('PRORANK_FEEDBACK_ENDPOINT')) {
    define('PRORANK_FEEDBACK_ENDPOINT', PRORANK_API_BASE . '/v1/feedback');
}

if (!defined('PRORANK_IMAGE_OPTIMIZE_ENDPOINT')) {
    define('PRORANK_IMAGE_OPTIMIZE_ENDPOINT', PRORANK_API_BASE . '/v1/optimize');
}

// Report Generation Endpoint
if (!defined('PRORANK_REPORT_GENERATE_ENDPOINT')) {
    define('PRORANK_REPORT_GENERATE_ENDPOINT', PRORANK_API_BASE . '/v1/reports/generate');
}

// Feedback Endpoint
if (!defined('PRORANK_FEEDBACK_ENDPOINT')) {
    define('PRORANK_FEEDBACK_ENDPOINT', PRORANK_API_BASE . '/v1/feedback');
}

// License API Endpoints
if (!defined('PRORANK_LICENSE_VALIDATE_URL')) {
    define('PRORANK_LICENSE_VALIDATE_URL', PRORANK_API_BASE . '/wp/validate');
}

if (!defined('PRORANK_LICENSE_ACTIVATE_URL')) {
    define('PRORANK_LICENSE_ACTIVATE_URL', PRORANK_API_BASE . '/wp/activate');
}

if (!defined('PRORANK_LICENSE_DEACTIVATE_URL')) {
    define('PRORANK_LICENSE_DEACTIVATE_URL', PRORANK_API_BASE . '/wp/deactivate');
}

if (!defined('PRORANK_LICENSE_CHECK_UPDATE_URL')) {
    define('PRORANK_LICENSE_CHECK_UPDATE_URL', PRORANK_API_BASE . '/wp/check-update');
}

if (!defined('PRORANK_LICENSE_CHANGELOG_URL')) {
    define('PRORANK_LICENSE_CHANGELOG_URL', PRORANK_API_BASE . '/wp/changelog');
}

// Marketing Links
if (!defined('PRORANK_PRICING_URL')) {
    define('PRORANK_PRICING_URL', PRORANK_WEB_URL . '/pricing');
}

if (!defined('PRORANK_FEATURES_URL')) {
    define('PRORANK_FEATURES_URL', PRORANK_WEB_URL . '/features');
}

if (!defined('PRORANK_BLOG_URL')) {
    define('PRORANK_BLOG_URL', PRORANK_WEB_URL . '/blog');
}

if (!defined('PRORANK_CHANGELOG_URL')) {
    define('PRORANK_CHANGELOG_URL', PRORANK_WEB_URL . '/changelog');
}

// Legal Pages
if (!defined('PRORANK_PRIVACY_URL')) {
    define('PRORANK_PRIVACY_URL', PRORANK_WEB_URL . '/privacy');
}

if (!defined('PRORANK_TERMS_URL')) {
    define('PRORANK_TERMS_URL', PRORANK_WEB_URL . '/terms');
}

if (!defined('PRORANK_CONTACT_URL')) {
    define('PRORANK_CONTACT_URL', PRORANK_WEB_URL . '/contact');
}

// User Account Links
if (!defined('PRORANK_ACCOUNT_LICENSES_URL')) {
    define('PRORANK_ACCOUNT_LICENSES_URL', PRORANK_ACCOUNT_URL . '/licenses');
}

if (!defined('PRORANK_ACCOUNT_BILLING_URL')) {
    define('PRORANK_ACCOUNT_BILLING_URL', PRORANK_ACCOUNT_URL . '/billing');
}

if (!defined('PRORANK_ACCOUNT_SUPPORT_URL')) {
    define('PRORANK_ACCOUNT_SUPPORT_URL', PRORANK_ACCOUNT_URL . '/support');
}
