<?php
/**
 * JWT Configuration for ProRank SEO
 *
 * This file defines the JWT secret used for license validation.
 * IMPORTANT: Keep this secret secure and match it with the server's JWT_SECRET
 *
 * @package ProRank\SEO
 */

defined( 'ABSPATH' ) || exit;

// JWT secret should NOT be in the plugin - removed for security
// The webapp handles all JWT operations internally

// JWT algorithm (must match server)
if (!defined('PRORANK_JWT_ALGORITHM')) {
    define('PRORANK_JWT_ALGORITHM', 'HS256');
}

// JWT expiration time (in seconds)
if (!defined('PRORANK_JWT_EXPIRATION')) {
    define('PRORANK_JWT_EXPIRATION', 86400); // 24 hours
}