<?php
/**
 * Uninstall handler for ProRank SEO.
 *
 * @package ProRank\SEO
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange

/**
 * Cleanup data for a single site.
 *
 * @return void
 */
function prorank_seo_uninstall_site(): void {
    $autoload = __DIR__ . '/includes/autoload.php';
    if ( file_exists( $autoload ) ) {
        require_once $autoload;
    }

    if ( class_exists( 'ProRank\\SEO\\Core\\Lifecycle' ) ) {
        ProRank\SEO\Core\Lifecycle::uninstall();
    }

    global $wpdb;

    $cron = _get_cron_array();
    if ( is_array( $cron ) ) {
        foreach ( $cron as $hooks ) {
            foreach ( $hooks as $hook => $events ) {
                if ( strpos( $hook, 'prorank_' ) === 0 ) {
                    wp_clear_scheduled_hook( $hook );
                }
            }
        }
    }

    if ( function_exists( 'as_unschedule_all_actions' ) ) {
        $action_hooks = [
            'prorank_external_css_download',
            'prorank_external_css_download_retry',
            'prorank_css_cache_generation',
        ];

        foreach ( $action_hooks as $hook ) {
            as_unschedule_all_actions( $hook, [], 'prorank-seo' );
        }
    }

    $option_like = $wpdb->esc_like( 'prorank_' ) . '%';
    $private_like = $wpdb->esc_like( '_prorank_' ) . '%';
    $transient_like = $wpdb->esc_like( '_transient_prorank_' ) . '%';
    $site_transient_like = $wpdb->esc_like( '_site_transient_prorank_' ) . '%';

    // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Options table is safe.
    $wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s", $option_like ) );
    // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Options table is safe.
    $wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s", $private_like ) );
    // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Options table is safe.
    $wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s", $transient_like ) );
    // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Options table is safe.
    $wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s", $site_transient_like ) );

    $tables = [
        'prorank_psi_history',
        'prorank_voice_analytics',
        'prorank_audit_log',
        'prorank_ai_content_library',
        'prorank_ai_templates',
        'prorank_ai_generation_history',
        'prorank_audits',
        'prorank_audit_urls',
        'prorank_audit_issues',
        'prorank_redirects',
        'prorank_404_monitor',
        'prorank_redirect_logs',
        'prorank_external_css_queue',
        'prorank_css_cache',
        'prorank_link_clicks',
        'prorank_broken_links',
        'prorank_sustainability_history',
    ];

    foreach ( $tables as $table ) {
        $table_name = $wpdb->prefix . $table;
        // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter -- Custom table name is safe.
        $wpdb->query( "DROP TABLE IF EXISTS {$table_name}" );
    }

    delete_option( 'prorank_redirects_db_version' );
    delete_option( 'prorank_sustainability_history_db_version' );
}

if ( is_multisite() ) {
    $prorank_site_ids = get_sites( [ 'fields' => 'ids' ] );
    foreach ( $prorank_site_ids as $prorank_site_id ) {
        switch_to_blog( $prorank_site_id );
        prorank_seo_uninstall_site();
        restore_current_blog();
    }
} else {
    prorank_seo_uninstall_site();
}

// phpcs:enable WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange
